//*********************************************************************************
//**
//** Project.........: Magnetic Loop Controller
//**
//**
//**
//** Platform........: AT90usb1286 @ 16MHz
//**
//** Licence.........: This software is freely available for non-commercial 
//**                   use only - i.e. for research and experimentation.
//**
//** Initial version.: 2012-10-20, Loftur Jonasson, TF3LJ / VE2LJX
//**
//**
//** History.........: Check the ML.c file
//**
//*********************************************************************************

#include "ML.h"

#define OP_FRQ	00

uint8_t civ_read[5];			// CI-V data as a 5 char bcd
uint32_t civ_value;				// CI-V data as a 32bit integer
uint32_t civ_prev_value;		// Previously read CI-V data

//
// Parse CI-V data
//																																																																				
void civ_Parser(void)
{
	static uint8_t civ_temp[5];	// temporary CI-V data as a 5 char bcd
	uint8_t serialRx;			// received byte from serial port (usart)
	static uint8_t i=0;			// message byte count for parser
	uint8_t j,k;

	if((serialRx = usart_Receive()) != 0xff)
	{
/*
		// DEBUG print the received string
		static uint8_t k=0;
		lcdGotoXY(k,1);
		rprintf("%02x",serialRx);
		k+=2;
		//if (k==20) k=0;
		if (serialRx==0xfd) k=0;
*/

		if ((i==0) && (serialRx==0xfe)) i++;	// legit header received
												// start parsing
		// Parse
		else if (i>0)
		{
			// First bytes are not relevant
			if (i<4) i++;						
			
			// Check if this is indicated as a Frequency message
			else if (i==4)
			{
				 if (serialRx == OP_FRQ) i++;
				 else i=0;						// Not relevant data, stop parsing
			}

			// We have a full string
			else if ((i>9) || (serialRx == 0xfd))
			{
				if (i>8)						// String is 4 or 5 bytes, valid
				{
					j=0,k=0;
					if (i==9)					// 4 byte string
					{
						civ_read[j] = 0;		// therefore pad with zero for 5 bytes
						j++;
					}
					// Read into a 5 byte BCD
					for (;j<5;j++,k++)
						civ_read[j] = civ_temp[k];

					// Convert BCD to value
					civ_value = (civ_read[0] & 0x0f);					// Hz
					civ_value += 10 * ((civ_read[0] & 0xf0)>>4);		// 10 x Hz
					
					civ_value += 100 *  (civ_read[1] & 0x0f);			// 100 x Hz
					civ_value += 1000 * ((civ_read[1] & 0xf0)>>4);		// kHz
					
					civ_value += (uint32_t) 10000 * (civ_read[2] & 0x0f);			// 10 x kHz
					civ_value += (uint32_t) 100000 * ((civ_read[2] & 0xf0)>>4);		// 100 x kHz
					
					civ_value += (uint32_t) 1000000 * (civ_read[3] & 0x0f);			// MHz
					civ_value += (uint32_t) 10000000 * ((civ_read[3] & 0xf0)>>4);	// 10 x MHz
					
					civ_value += (uint32_t) 100000000 * (civ_read[4] & 0x0f);		// 100 x MHz
					civ_value += (uint32_t) 1000000000 * ((civ_read[4] & 0xf0)>>4);	// GHz

					//
					// Update running frequency of the application
					//
					if ((civ_value > 1000000) && (civ_value < 31000000))	// Impose some sane boundaries
					{
						if (civ_value == civ_prev_value)					// Update frequency if read output is stable
						{
							R.curFrq = civ_value;
						}
						civ_prev_value = civ_value;							// Update "previous" value for next round
						
						Status |= FRQ_RADIO;	// Indicate that we are receiving frq data from Radio
					}
				}
				i=0;							// Done parsing, whether relevant or not
			}

			// Else pull frequency data
			else if (i>4) 
			{
				civ_temp[i-5]=serialRx;
				i++;
			}
		}
	}
}
